function UpdateImage(handles)
% UpdateImage is the second step of plotting images. However, with only
% minor changes to the image, e.g. normalization, Gaussian smoothing, or by
% changing the energy slice, the whole handle does not need to be reloaded.

%% Get handles
Data      =            get(handles.CAxisMin,'UserData');
Range     =            get(handles.Slider, 'SliderStep');
DispRange = str2double(get(handles.DispRange,'String'));
MaxMin    =            get(handles.Slider, 'UserData');
Value     =            get(handles.Slider, 'Value');
Energies  =            get(handles.ZLPAlign,'UserData');

%% Calculate
Value      = round(Value/Range(1))*Range(1);
Image      = Data{1};
B          = Data{2};
AxisX      = Data{3};
AxisY      = Data{4};
TotalMin   = MaxMin(2);
Pos        = round((Value -TotalMin)/Range(1))+1;
DispRange  = round((DispRange-1)/2);
DispRange  = DispRange/Range(1);
Image      = mean(Image(:,:,(Pos-DispRange):(Pos+DispRange)),3);

Pos  = Energies(1,Pos);
Data = {Image,B,AxisX,AxisY};

%% Set Handles
set(handles.DispEnergy,'String',num2str(Pos));
set(handles.CAxisMax,'UserData',Data);

%% Plot
PlotImg(handles);
clearvars all

end